<?php
/*
Plugin Name: Mouse Movement Simulator
Plugin URI: https://majdi.ir
Description: Simulates mouse movement, random scrolling, and random clicks on menu links every 5 seconds on active pages, with 95% of mouse movements within the content area. All movements stop until the next 5-second cycle.
Version: 1.3.0
Author: majdi
Author URI: https://majdi.ir
License: GPL2
Text Domain: mouse-movement-simulator
*/

// جلوگیری از دسترسی مستقیم به فایل
if (!defined('ABSPATH')) {
    exit;
}

class MouseMovementSimulator {
    public function __construct() {
        // اضافه کردن اسکریپت‌ها به فرانت‌اند
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
    }

    public function enqueue_scripts() {
        // فقط در صفحات فرانت‌اند اجرا شود
        if (is_admin()) {
            return;
        }

        // ثبت و بارگذاری jQuery
        wp_enqueue_script('jquery');

        // اضافه کردن اسکریپت سفارشی
        wp_add_inline_script('jquery', $this->get_simulation_script());
    }

    private function get_simulation_script() {
        return '
        jQuery(document).ready(function($) {
            // تولید 1000 مختصات تصادفی غیرتکراری
            function generateRandomCoordinates() {
                var coordinates = [];
                var safeZone = 0.95; // 95% حرکات در باکس محتوا
                var contentArea = {
                    width: Math.floor(window.innerWidth * 0.9), // 90% عرض صفحه
                    height: Math.floor(window.innerHeight * 0.9), // 90% ارتفاع صفحه
                    offsetX: Math.floor(window.innerWidth * 0.05), // حاشیه 5%
                    offsetY: Math.floor(window.innerHeight * 0.05) // حاشیه 5%
                };

                while (coordinates.length < 1000) {
                    var x = Math.floor(Math.random() * window.innerWidth);
                    var y = Math.floor(Math.random() * window.innerHeight);

                    // 95% در باکس محتوا
                    if (Math.random() < safeZone) {
                        x = contentArea.offsetX + Math.floor(Math.random() * contentArea.width);
                        y = contentArea.offsetY + Math.floor(Math.random() * contentArea.height);
                    }

                    // بررسی عدم تکرار
                    var isUnique = coordinates.every(function(coord) {
                        return Math.abs(coord.x - x) > 10 || Math.abs(coord.y - y) > 10;
                    });

                    if (isUnique) {
                        coordinates.push({x: x, y: y});
                    }
                }
                return coordinates;
            }

            // پیدا کردن لینک‌های منو
            function getMenuLinks() {
                // جستجو در تگ‌های nav]s> معمولاً در nav یا با کلاس‌های رایج منو
                return $("nav a, .menu a, .main-menu a, .navigation a");
            }

            var randomCoordinates = generateRandomCoordinates();
            var coordinateIndex = 0;
            var isSimulating = false;
            var isUserActive = false;

            // شبیه‌سازی حرکت موس و کلیک رندوم
            function simulateMouseMovement() {
                if (isSimulating || isUserActive) return;
                isSimulating = true;

                // شبیه‌سازی حرکت موس
                var coord = randomCoordinates[coordinateIndex];
                var event = new Event("mousemove");
                event.clientX = coord.x;
                event.clientY = coord.y;
                document.dispatchEvent(event);

                // به‌روزرسانی اندیس برای مختصات بعدی
                coordinateIndex = (coordinateIndex + 1) % randomCoordinates.length;

                // شبیه‌سازی اسکرول رندوم
                var scrollX = Math.floor(Math.random() * 200) - 100; // بین -100 تا +100 پیکسل
                var scrollY = Math.floor(Math.random() * 200) - 100; // بین -100 تا +100 پیکسل
                window.scrollBy({
                    top: scrollY,
                    left: scrollX,
                    behavior: "smooth"
                });

                // کلیک رندوم روی لینک‌های منو (با احتمال 20%)
                if (Math.random() < 0.2) {
                    var menuLinks = getMenuLinks();
                    if (menuLinks.length > 0) {
                        var randomLink = menuLinks.eq(Math.floor(Math.random() * menuLinks.length));
                        randomLink[0].click(); // کلیک روی لینک تصادفی
                    }
                }

                // توقف تا چرخه بعدی
                setTimeout(function() {
                    isSimulating = false;
                }, 500); // توقف کوتاه برای تکمیل حرکت
            }

            // اجرای شبیه‌سازی هر 5 ثانیه
            setInterval(simulateMouseMovement, 5000);

            // توقف شبیه‌سازی وقتی کاربر واقعاً با صفحه تعامل می‌کند
            $(document).on("mousemove keydown scroll", function() {
                isUserActive = true;
                setTimeout(function() {
                    isUserActive = false;
                }, 5000); // 5 ثانیه پس از آخرین تعامل
            });
        });
        ';
    }
}

// اجرای پلاگین
new MouseMovementSimulator();